<?php
header('Content-Type: application/json');

// Identitas server
$hostname = gethostname();
$servername = basename(__DIR__);

// Disk usage
$disk_total = @disk_total_space("/");
$disk_free = @disk_free_space("/");
$disk_used_pct = $disk_total > 0 ? round((1 - $disk_free / $disk_total) * 100, 2) : 0;
$disk_free_gb = round($disk_free / (1024 ** 3), 2);

// RAM usage
$ram_usage = 0;
$meminfo = @file_get_contents("/proc/meminfo");
if ($meminfo) {
    preg_match("/MemTotal:\s+(\d+)/", $meminfo, $matches_total);
    preg_match("/MemAvailable:\s+(\d+)/", $meminfo, $matches_free);
    if (!empty($matches_total) && !empty($matches_free)) {
        $ram_total = $matches_total[1];
        $ram_free = $matches_free[1];
        $ram_usage = round((1 - $ram_free / $ram_total) * 100, 2);
    }
}

// CPU load average
$load = @sys_getloadavg();
$load_1 = isset($load[0]) ? round($load[0], 2) : 0;
$load_5 = isset($load[1]) ? round($load[1], 2) : 0;
$load_15 = isset($load[2]) ? round($load[2], 2) : 0;
$cpu_usage = $load_1; // optional: tampilkan load 1 menit

// Cek MySQL
$mysql_ok = false;
$mysqli = @new mysqli('localhost', 'root', '', '');
if ($mysqli && !$mysqli->connect_error) {
    $mysql_ok = true;
}
@mysqli_close($mysqli);

// Cek HTTP status
$http_status = 0;
$ch = @curl_init("https://{$hostname}");
@curl_setopt($ch, CURLOPT_NOBODY, true);
@curl_setopt($ch, CURLOPT_TIMEOUT, 3);
@curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
@curl_exec($ch);
if (!@curl_errno($ch)) {
    $http_status = @curl_getinfo($ch, CURLINFO_HTTP_CODE);
}
@curl_close($ch);

// Keluarkan hasil JSON
$data = [
    'host' => $hostname,
    'server' => $servername,
    'disk_used_pct' => $disk_used_pct,
    'disk_free_gb' => $disk_free_gb,
    'ram_usage' => $ram_usage,
    'cpu_usage' => $cpu_usage,
    'load' => [
        '1min' => $load_1,
        '5min' => $load_5,
        '15min' => $load_15
    ],
    'http_status' => $http_status,
    'mysql_status' => $mysql_ok,
    'ts' => date('Y-m-d H:i:s'),
    'ts_recv' => microtime(true)
];

echo json_encode($data, JSON_PRETTY_PRINT);
?>
